/*
 *  Copyright 2007 by Spectrum Digital Incorporated.
 *  All rights reserved. Property of Spectrum Digital Incorporated.
 */

/*
 *  Video Loopback Test
 *
 */

#include "stdio.h"
#include "dm388_hdmi.h"

//#define OSD_EXTEND_MODE    *( volatile Uint32* )( OSD_BASE + 0xE4 )

#if 0
void Setup_PLL0_HD()
{
    unsigned int* pll_ctl       = ( unsigned int* )( 0x01c40900 );
    unsigned int* pll_secctl    = ( unsigned int* )( 0x01c40908 );
    unsigned int* pll_cmd       = ( unsigned int* )( 0x01c40938 );
    unsigned int* pll_div6      = ( unsigned int* )( 0x01c40968 );

    /* Reconfigure SYSCLK6 divider for VENC = 74.25MHz */
    *pll_ctl &= ~0x0002;              // Power up PLL
    *pll_ctl |=  0x0010;              // Put PLL in disable mode
    *pll_ctl &= ~0x0010;              // Take PLL out of disable mode

    *pll_ctl &= ~0x0020;             // Clear PLLENSRC
    *pll_ctl &= ~0x0001;             // Set PLL in bypass
    EVMDM365_waitusec( 150 );

    *pll_ctl |= 0x0008;              // Assert PLL reset
    *pll_ctl &= ~0x0008;             // Take PLL out of reset

    *pll_ctl &= ~0x0010;             // Enable PLL
    EVMDM365_waitusec( 150 );        // Wait for PLL to stabilize

    _wait (100 );

    *pll_secctl  = 0x00470000;       // Assert TENABLE = 1, TENABLEDIV = 1, TINITZ = 1 
    *pll_secctl  = 0x00460000;       // Assert TENABLE = 1, TENABLEDIV = 1, TINITZ = 0 
    *pll_secctl  = 0x00400000;       // Assert TENABLE = 0, TENABLEDIV = 0, TINITZ = 0 
    *pll_secctl  = 0x00410000;       // Assert TENABLE = 0, TENABLEDIV = 0, TINITZ = 1

    *pll_div6    = 0x8007;           // 594/8 -> 74.25MHz VENC

    *pll_cmd |= 0x0001;              // Set GOSET

    EVMDM365_waitusec( 2000 );

    while(! (((PLL0_CONFIG) & 0x07000000) == 0x07000000));  // Wait for PLL to lock

    EVMDM365_waitusec( 2000 );
    *pll_ctl = 0x0001;               // Enable PLL
}


/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  vpbe_init( )                                                            *
 *                                                                          *
 * ------------------------------------------------------------------------ */
static void vpbe_init( )
{
    /*
     * Setup clocking / DACs
     */
    VDAC_CONFIG         = 0x081141EF;   // Take DACs out of power down mode, enable HD component out
    VPSS_CLKCTL         = 0x00000018;   // Enable DAC and VENC clock
    VPSS_VPBE_CLK_CTRL  = 0x00000011;   // Select enc_clk*1, turn on VPBE clk
	VENC_CLKCTL         = 0x00000011;   // Enable venc & digital LCD clock
    VENC_XHINTVL        = 0x00000000;   // Extend standard 720P horizontal timing

    /*
     *  Setup VENC
     */
    VENC_VMOD   = 0x01c3;   // 1080i
    VENC_VDPRO  = 0x0100;   // Colorbars not normal display mode
    VENC_DACTST = 0x0000;   // Power on DACs
    VENC_DACSEL = 0x0543;   // Component out on DACs
}
#endif

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  video_colorbars_test( )                                                 *
 *                                                                          *
 *                                                                          *
 *                                                                          *
 * ------------------------------------------------------------------------ */
Int16 video_colorbars_test( )
{
    Uint16 *pdata;
    Uint32 x, y;

    //PLL and HDMI Configuration is already done in dm388 gel file
#if 0
    /* Reconfigure SYSCLK6 divider for VENC = 74.25MHz */
    Setup_PLL0_HD();

    /* Board video components setup */
	EVMDM365_CPLD_rset(3, 0x01);     // Select TVP7002 on decoder MUX

	ths7303_setup( MODE_HDTV_720P );   // Component output filter

	EVMDM365_waitusec(100000);

  //configuration are done in dm388 gel file
   vpbe_init( );


    /* Enable LCD outputs for test */
    VPSS_MISR_CTRL = 0x0003;
	VENC_VIOCTL    = 0x2000;
	VENC_SYNCCTL   = 0x0003;
	VENC_LCDOUT    = 0x0001;
	VENC_DCLKCTL   = 0x8800;
	VENC_DCLKPTN0  = 0x0001;
#endif

    LCD_VPSS_Config();

	pdata = (Uint16 *)0x80000000;

    /* Fill screen with green */
	for (x = 0; x < (720 * 816); x++)
	    *pdata++ = 0xff00;
#if(1)
    /* Draw vertical line */
    pdata = (Uint16 *)0x80000000;
	for (y = 128; y < 144; y++)
	    pdata[y * 816 + 200] = 0x1080;

	/* Draw horizontal line */
	for (x = 0; x < 816 ; x++)
	    pdata[128 * 816 + x] = 0x1040;
	for (x = 0; x < 816 ; x++)
	    pdata[130 * 816 + x] = 0x1040;
	for (x = 0; x < 816 ; x++)
	    pdata[256 * 816 + x] = 0x1040;
#endif

	// 720P 841
	// 1080i 1116

    return 0;
}
